/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.program.ExecuteProgramBehaviour;
import ca.teamdman.sfm.common.program.ProgramBehaviour;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.program.SimulateExploreAllPathsProgramBehaviour;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.Label;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public record ForgetStatement(Set<Label> labelToForget) implements Statement
{
    @Override
    public void tick(ProgramContext context) {
        ArrayList<InputStatement> newInputs = new ArrayList<InputStatement>();
        for (InputStatement oldInputStatement : context.getInputs()) {
            ProgramBehaviour programBehaviour;
            List<Label> newLabels = oldInputStatement.labelAccess().labels().stream().filter(label -> !this.labelToForget.contains(label)).toList();
            InputStatement newInputStatement = new InputStatement(new LabelAccess(newLabels, oldInputStatement.labelAccess().sides(), oldInputStatement.labelAccess().slots(), oldInputStatement.labelAccess().roundRobin()), oldInputStatement.resourceLimits(), oldInputStatement.each());
            if (!(context.getBehaviour() instanceof ExecuteProgramBehaviour)) {
                context.getProgram().astBuilder().setLocationFromOtherNode(newInputStatement, oldInputStatement);
            }
            if ((programBehaviour = context.getBehaviour()) instanceof SimulateExploreAllPathsProgramBehaviour) {
                SimulateExploreAllPathsProgramBehaviour simulation = (SimulateExploreAllPathsProgramBehaviour)programBehaviour;
                simulation.onInputStatementForgetTransform(context, oldInputStatement, newInputStatement);
            }
            oldInputStatement.freeSlotsIf(slot -> this.labelToForget.contains(slot.label));
            oldInputStatement.transferSlotsTo(newInputStatement);
            if (newLabels.isEmpty()) {
                oldInputStatement.freeSlots();
                continue;
            }
            newInputs.add(newInputStatement);
        }
        context.getInputs().clear();
        context.getInputs().addAll(newInputs);
        context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_FORGET_STATEMENT.get(this.labelToForget.stream().map(Objects::toString).collect(Collectors.joining(", ")))));
    }

    @Override
    public String toString() {
        return "FORGET " + this.labelToForget.stream().map(Objects::toString).collect(Collectors.joining(", "));
    }
}

